/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.setup;

import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.entity.projectile.PenetrationData;
import dev.toma.gunsrpg.common.item.BaseItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoMaterialManager;
import dev.toma.gunsrpg.common.item.guns.setup.MaterialContainer;
import dev.toma.gunsrpg.common.item.guns.util.Firemode;
import dev.toma.gunsrpg.util.object.RGB2TextFormatting;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class AbstractGun
extends BaseItem {
    protected static Random random = new Random();

    public AbstractGun(String name, Item.Properties properties) {
        super(name, properties);
    }

    public abstract MaterialContainer getContainer();

    public PenetrationData getPenetrationData(IPlayerData data) {
        return null;
    }

    public static int getAmmoCount(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74762_e("ammo");
        }
        return 0;
    }

    public final void setFiremode(ItemStack stack, Firemode firemode) {
        this.ensureHasNBT(stack);
        stack.func_77978_p().func_74768_a("firemode", firemode.ordinal());
    }

    public final Firemode getFiremode(ItemStack stack) {
        this.ensureHasNBT(stack);
        return Firemode.get(stack.func_77978_p().func_74762_e("firemode"));
    }

    public void ensureHasNBT(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("firemode")) {
            return;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("ammo", 0);
        nbt.func_74768_a("firemode", this.getDefaultFiremode().ordinal());
        nbt.func_74776_a("repairDurability", 1.0f);
        stack.func_77982_d(nbt);
    }

    public IAmmoMaterial getMaterialFromNBT(ItemStack stack) {
        this.ensureHasNBT(stack);
        CompoundNBT nbt = stack.func_77978_p();
        AmmoMaterialManager materialManager = AmmoMaterialManager.get();
        return materialManager.parse(nbt);
    }

    public int getAmmo(ItemStack stack) {
        this.ensureHasNBT(stack);
        return stack.func_77978_p().func_74762_e("ammo");
    }

    public void setAmmoCount(ItemStack stack, int count) {
        this.ensureHasNBT(stack);
        CompoundNBT nbt = stack.func_77978_p();
        nbt.func_74768_a("ammo", Math.max(0, count));
    }

    public boolean hasAmmo(ItemStack stack) {
        return this.getAmmo(stack) > 0;
    }

    public final int getDamageBonus(ItemStack stack) {
        IAmmoMaterial material = this.getMaterialFromNBT(stack);
        return material != null ? this.getContainer().getAdditionalDamage(material) : 0;
    }

    public final void setJammedState(ItemStack stack, boolean state) {
        this.ensureHasNBT(stack);
        CompoundNBT nbt = stack.func_77978_p();
        nbt.func_74757_a("jammed", state);
    }

    public final boolean isJammed(ItemStack stack) {
        this.ensureHasNBT(stack);
        return stack.func_77978_p().func_74767_n("jammed");
    }

    public final void setDurabilityLimit(ItemStack stack, float durability) {
        this.ensureHasNBT(stack);
        stack.func_77978_p().func_74776_a("repairDurability", durability);
    }

    public final float getDurabilityLimit(ItemStack stack) {
        this.ensureHasNBT(stack);
        return stack.func_77978_p().func_74760_g("repairDurability");
    }

    protected Firemode getDefaultFiremode() {
        return Firemode.SINGLE;
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 0.0f;
    }

    public boolean func_195938_a(BlockState blockState, World world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        IAmmoMaterial material = this.getMaterialFromNBT(stack);
        TextFormatting formatting = material != null ? RGB2TextFormatting.getClosestFormat(material.getTextColor()) : TextFormatting.GRAY;
        IFormattableTextComponent materialInstance = new StringTextComponent(material != null ? material.getDisplayName().getString() : "???").func_240699_a_(formatting);
        TranslationTextComponent materialComponent = new TranslationTextComponent("gun.material", new Object[]{materialInstance});
        list.add((ITextComponent)materialComponent);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }
}

